/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.effects;

import org.eclipse.swt.*;
import org.eclipse.swt.internal.wpf.*;

public class CompositeEffect extends Effect {
	void createHandle() {
		handle = OS.gcnew_BitmapEffectGroup();
		if (handle == 0) SWT.error(SWT.ERROR_NO_HANDLES);
	}
	
	public void addEffect(Effect effect) {
		checkEffect();
		int children = OS.BitmapEffectGroup_Children(handle);
		OS.IList_Add(children, effect.handle);
		OS.GCHandle_Free(children);
	}
	
	public void removeEffect(Effect effect) {
		checkEffect();
		int children = OS.BitmapEffectGroup_Children(handle);
		OS.IList_Remove(children, effect.handle);
		OS.GCHandle_Free(children);
	}
}
